import logging
from cse_image_items.BaseItem import BaseItem
from cse_image_items.DataItem import DataItem
from cse_image_items.BootPartition import BootPartition
from cse_image_items.CSELayoutPointers import CSELayoutPointers


logger = logging.getLogger(__name__)

class CSERegion(BaseItem):
    def __init__(self, data, **kwargs):
        logger.info('START CSERegion.__init__ FUNCTION')
        
        super(CSERegion,self).__init__(data, **kwargs)
        self.layout_pointers = CSELayoutPointers(
            self.value, **kwargs['layout_pointers'])
        self.set_logical_boot_partitions(
            kwargs['logical_boot_partition'], kwargs['layout_pointers']['logical_boot_partitions'])

    def set_logical_boot_partitions(self, logical_boot_partition, logical_boot_partitions):
        self.logical_boot_partitions = []
        for bpdt in logical_boot_partitions:
            bpdt_offset = DataItem(self.value, **bpdt['offset'])
            # check if bpdt is in use
            if bpdt_offset.int_value() == 0:
                continue
            logical_boot_partition['offset'] = bpdt_offset.hex_value()
            logical_boot_partition['size'] = DataItem(
                self.value, **bpdt['size']).hex_value()
            self.logical_boot_partitions.append(BootPartition(
                self.value, **logical_boot_partition))
